// Files to cache
const cacheName = 'ishopmanpwa-v1';
//Khong duoc trung files, trung se khong chay
const appShellFiles = [
    './',
    '/index.js',
    '/indexmenu.js',
    '/favicon.ico',
    '/style.css',
    '/style_menu.css',
    '/js/jquery-3.6.0.min.js',
    '/js/jquery-ui.min.css',
    '/js/datetimepicker.js',
    '/js/inputformat.js',
    '/js/ishopman.js',
    '/js/md5.js',
    '/js/qr-scanner.min.js',
    '/js/qr-scanner.umd.min.js',
    '/js/qr-scanner-worker.min.js',
    '/data/language.txt',
    '/imgs/bt_add.png',
    '/imgs/bt_find.png',
    '/imgs/bt_grid.gif',
    '/imgs/bt_loading.gif',
    '/imgs/bt_ok.gif',
    '/imgs/bt_print.gif',
    '/imgs/bt_sort.gif',
    '/imgs/bt_reload.png',
];
const contentToCache = appShellFiles;

//self.caches.delete(cacheName);

// Installing Service Worker
self.addEventListener("install", (e) => {
    console.log('[Service Worker] Install');
    e.waitUntil((async () => {
        const cache = await caches.open(cacheName);
        console.log('[Service Worker] Caching all: app shell and content');
        await cache.addAll(contentToCache);
    })());
});

// Fetching content using Service Worker
self.addEventListener("fetch", (e) => {
    e.respondWith((async () => {
        const r = await caches.match(e.request);
        console.log('[Service Worker] Fetching resource: ${e.request.url}');
        if (r) return r;
        const response = await fetch(e.request);
        const cache = await caches.open(cacheName);
        console.log(`[Service Worker] Caching new resource: ${e.request.url}`);
        cache.put(e.request, response.clone());
        return response;
    })());
});